; -------------------------------------------------------------------------------------------------------------- ;
; Beach Head - Chapter Data: Bay Map
; -------------------------------------------------------------------------------------------------------------- ;
                        incdir  ..\inc              ; C64 System Includes
;
C64CIA2                 include cia2.asm            ; Complex Interface Adapter (CIA) #2 Registers  $DD00-$DD0F
C64VicII                include vic.asm             ; Video Interface Chip (VIC-II) Registers       $D000-$D02E
C64Colors               include color.asm           ; Colour RAM Address / Colours
;
Game                    include inc\BH_Game.asm     ; Game Variables
; -------------------------------------------------------------------------------------------------------------- ;
                        * = BH_MemScreenSetA
; -------------------------------------------------------------------------------------------------------------- ;
Screen_Graphics         set  * ; 
;                            $00  $01  $02  $03  $04  $05  $06  $07  $08  $09  $0a  $0b  $0c  $0d  $0e  $0f  $10  $11  $12  $13  $14  $15  $16  $17  $18  $19  $1a  $1b  $1c  $1d  $1e  $1f  $20  $21  $22  $23  $24  $25  $26  $27 ; 
Screen_BayMap_Row01     dc.b $01, $02, $03, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ; 
Screen_BayMap_Row02     dc.b $98, $04, $05, $06, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ; 
Screen_BayMap_Row03     dc.b $98, $98, $98, $07, $08, $09, $0a, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ; 
Screen_BayMap_Row04     dc.b $98, $98, $98, $98, $98, $98, $0b, $0c, $0d, $0e, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ; 
Screen_BayMap_Row05     dc.b $0f, $10, $11, $12, $13, $14, $15, $16, $17, $18, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ; 
Screen_BayMap_Row06     dc.b $00, $00, $00, $00, $00, $00, $00, $00, $19, $1a, $1b, $1c, $1d, $1e, $1f, $20, $21, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ; 
Screen_BayMap_Row07     dc.b $00, $00, $00, $00, $00, $00, $00, $00, $00, $22, $23, $24, $25, $26, $27, $98, $28, $29, $2a, $2b, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ; 
Screen_BayMap_Row08     dc.b $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $2c, $2d, $2e, $98, $98, $2f, $30, $31, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ; 
Screen_BayMap_Row09     dc.b $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $32, $33, $34, $98, $98, $35, $36, $37, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ; 
Screen_BayMap_Row0a     dc.b $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $38, $39, $98, $3a, $98, $98, $3b, $3c, $3d, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ; 
Screen_BayMap_Row0b     dc.b $63, $64, $65, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $3e, $3f, $40, $41, $42, $43, $44, $45, $46, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ; 
Screen_BayMap_Row0c     dc.b $98, $98, $66, $67, $68, $69, $6a, $6b, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $47, $48, $00, $00, $00, $49, $4a, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ; 
Screen_BayMap_Row0d     dc.b $98, $98, $98, $98, $98, $98, $98, $6c, $6d, $6e, $6f, $70, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ; 
Screen_BayMap_Row0e     dc.b $98, $98, $98, $98, $98, $98, $98, $71, $72, $73, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $4b, $4c, $4d, $00, $00, $00, $00, $00 ; 
Screen_BayMap_Row0f     dc.b $98, $98, $98, $98, $98, $98, $98, $98, $74, $75, $76, $77, $78, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $4e, $4f, $50, $51, $52, $53, $54, $00 ; 
Screen_BayMap_Row10     dc.b $98, $98, $98, $98, $98, $98, $98, $79, $97, $97, $7a, $7b, $7c, $7d, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $55, $56, $57, $58, $00, $00, $59 ; 
Screen_BayMap_Row11     dc.b $98, $98, $98, $98, $98, $98, $7e, $97, $97, $7f, $7c, $7d, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $5a, $5b, $5c, $5d, $5e, $5f ; 
Screen_BayMap_Row12     dc.b $98, $82, $83, $84, $85, $86, $97, $97, $87, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $60, $61 ; 
Screen_BayMap_Row13     dc.b $88, $89, $8a, $8b, $8c, $97, $97, $97, $8e, $8f, $90, $91, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $62 ; 
Screen_BayMap_Row14     dc.b $98, $98, $98, $98, $98, $98, $98, $8d, $80, $81, $97, $97, $97, $97, $92, $93, $94, $95, $96, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ; 
                        
Screen_Status_Text      set *                          ; 
                        include inc\BH_StatusTexts.asm ; default texts
Screen_Status_Text_End  set *                          ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        * = [Status_Text_Row01 + BH_Scrn_Stat_LeTxt - $02] ; 
Screen_Status_Header    set *
                        dc.b "A" - $40 ; .hbu011.
                        dc.b "E" - $40 ; 
                        dc.b "R" - $40 ; 
                        dc.b "I" - $40 ; 
                        dc.b "A" - $40 ; 
                        dc.b "L" - $40 ; 
                        dc.b " "       ; 
                        dc.b "R" - $40 ; 
                        dc.b "E" - $40 ; 
                        dc.b "C" - $40 ; 
                        dc.b "O" - $40 ; 
                        dc.b "N" - $40 ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        * = Screen_BayMap_Row0c + $1a ; .hbu011. - barrier_1 top
Screen_BayMap_Barrier1  = *                           ; 
;                       dc.b $52, $53                 ; 
                        * = Screen_BayMap_Row0d + $1c ; .hbu011. - barrier_2 mid
Screen_BayMap_Barrier2  = *                           ; 
;                       dc.b $52, $53                 ; 
                        * = Screen_BayMap_Row0e + $1e ; .hbu011. - barrier_3 bottom
Screen_BayMap_Barrier3  = *                           ; 
;                       dc.b $52, $53                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        * = BH_MemScreenSetB
; -------------------------------------------------------------------------------------------------------------- ;
Chapter_Screen_Values   set  *      ; individual settings
Misc_BayMap_Raster      dc.b $cd    ; TabControlRaster
Misc_BayMap_St_Len      dc.b [Colors_Status_End - Colors_Status] ; copy status lenght
Misc_BayMap_St_Off_Lo   dc.b <[Colors_Status - Colors_Screen]    ; copy status offset
Misc_BayMap_St_Off_Hi   dc.b >[Colors_Status - Colors_Screen]    ; 
                        
Colors_Screen_Base      set  * ; 
                        dc.b BLUE   ; TabBackGroundColor
                        dc.b BLACK  ; BGCOL1
                        dc.b GREEN  ; BGCOL2
Colors_Screen           set  * ; 
;                            $00  $01  $02  $03  $04  $05  $06  $07  $08  $09  $0a  $0b  $0c  $0d  $0e  $0f  $10  $11  $12  $13  $14  $15  $16  $17  $18  $19  $1a  $1b  $1c  $1d  $1e  $1f  $20  $21  $22  $23  $24  $25  $26  $27 ; 
Colors_BayMap_Row01     dc.b $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f ; 
Colors_BayMap_Row02     dc.b $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f ; 
Colors_BayMap_Row03     dc.b $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f ; 
Colors_BayMap_Row04     dc.b $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f ; 
Colors_BayMap_Row05     dc.b $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f ; 
Colors_BayMap_Row06     dc.b $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f ; 
Colors_BayMap_Row07     dc.b $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f ; 
Colors_BayMap_Row08     dc.b $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $07, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f ; 
Colors_BayMap_Row09     dc.b $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $07, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f ; 
Colors_BayMap_Row0a     dc.b $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $07, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $07, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f ; 
Colors_BayMap_Row0b     dc.b $0f, $0f, $07, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $07, $07, $07, $07, $0f, $0f, $0f, $0f, $07, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f ; 
Colors_BayMap_Row0c     dc.b $0f, $0f, $0f, $0f, $0f, $0f, $0f, $07, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $07, $07, $0f, $0f, $0f, $07, $07, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f ; 
Colors_BayMap_Row0d     dc.b $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $07, $07, $07, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f ; 
Colors_BayMap_Row0e     dc.b $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $07, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $07, $07, $07, $0f, $0f, $0f, $0f, $0f ; 
Colors_BayMap_Row0f     dc.b $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $07, $07, $07, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $07, $0f, $0f, $07, $07, $07, $07, $0f ; 
Colors_BayMap_Row10     dc.b $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $07, $07, $07, $07, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $07, $0f, $0f, $07 ; 
Colors_BayMap_Row11     dc.b $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $07, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $07, $07, $07, $07, $07, $07 ; 
Colors_BayMap_Row12     dc.b $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $07, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $07, $0f ; 
Colors_BayMap_Row13     dc.b $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $07, $07, $07, $07, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f ; 
Colors_BayMap_Row14     dc.b $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $07, $07, $07, $0f, $07, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f ; 
                        
Colors_Status           set  * ; 
                        include inc\BH_StatusColor.asm ; default colors
Colors_Status_End       set  * ; 
                        
;Colors_Status_Free     dc.b $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ; unused - 3 for base
; -------------------------------------------------------------------------------------------------------------- ;
                        * = BH_MemCharSet
; -------------------------------------------------------------------------------------------------------------- ;
Chrset_BayMap           equ  *   ; 
                        
MapChar00               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar01               dc.b $00 ; ........
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        dc.b $bf ; #.######
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar02               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        
MapChar03               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $c0 ; ##......
                        
MapChar04               dc.b $ff ; ########
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar05               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $bf ; #.######
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar06               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $bc ; #.####..
                        dc.b $af ; #.#.####
                        
MapChar07               dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar08               dc.b $c0 ; ##......
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar09               dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $f0 ; ####....
                        dc.b $bc ; #.####..
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        
MapChar0a               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        
MapChar0b               dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar0c               dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar0d               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $af ; #.#.####
                        
MapChar0e               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        
MapChar0f               dc.b $aa ; #.#.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar10               dc.b $aa ; #.#.#.#.
                        dc.b $be ; #.#####.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $00 ; ........
                        
MapChar11               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $c0 ; ##......
                        dc.b $00 ; ........
                        
MapChar12               dc.b $aa ; #.#.#.#.
                        dc.b $be ; #.#####.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $f8 ; #####...
                        dc.b $c0 ; ##......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar13               dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $ef ; ###.####
                        dc.b $ff ; ########
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar14               dc.b $aa ; #.#.#.#.
                        dc.b $be ; #.#####.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $f0 ; ####....
                        dc.b $c0 ; ##......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar15               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        
MapChar16               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $0f ; ....####
                        
MapChar17               dc.b $af ; #.#.####
                        dc.b $af ; #.#.####
                        dc.b $bf ; #.######
                        dc.b $bf ; #.######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
MapChar18               dc.b $f0 ; ####....
                        dc.b $c0 ; ##......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        
MapChar19               dc.b $ff ; ########
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        
MapChar1a               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
MapChar1b               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fa ; #####.#.
                        dc.b $fa ; #####.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $fa ; #####.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar1c               dc.b $00 ; ........
                        dc.b $fc ; ######..
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar1d               dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar1e               dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar1f               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f4 ; ####.#..
                        dc.b $f5 ; ####.#.#
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        
MapChar20               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $07 ; .....###
                        dc.b $57 ; .#.#.###
                        dc.b $ff ; ########
                        dc.b $aa ; #.#.#.#.
                        
MapChar21               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        
MapChar22               dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar23               dc.b $fa ; #####.#.
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar24               dc.b $aa ; #.#.#.#.
                        dc.b $be ; #.#####.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $cf ; ##..####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        
MapChar25               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $00 ; ........
                        
MapChar26               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $fa ; #####.#.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        
MapChar27               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $fa ; #####.#.
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        
MapChar28               dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar29               dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar2a               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        
MapChar2b               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $30 ; ..##....
                        dc.b $3c ; ..####..
                        dc.b $ff ; ########
                        
MapChar2c               dc.b $ff ; ########
                        dc.b $0f ; ....####
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar2d               dc.b $ea ; ###.#.#.
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar2e               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $fa ; #####.#.
                        dc.b $fe ; #######.
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        
MapChar2f               dc.b $fc ; ######..
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar30               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        
MapChar31               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $e0 ; ###.....
                        
MapChar32               dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar33               dc.b $ea ; ###.#.#.
                        dc.b $fa ; #####.#.
                        dc.b $fe ; #######.
                        dc.b $3f ; ..######
                        dc.b $fe ; #######.
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        
MapChar34               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $fa ; #####.#.
                        dc.b $fe ; #######.
                        
MapChar35               dc.b $f0 ; ####....
                        dc.b $bc ; #.####..
                        dc.b $af ; #.#.####
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar36               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        
MapChar37               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f8 ; #####...
                        dc.b $ff ; ########
                        
MapChar38               dc.b $01 ; .......#
                        dc.b $01 ; .......#
                        dc.b $03 ; ......##
                        dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $1f ; ...#####
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        
MapChar39               dc.b $fe ; #######.
                        dc.b $fa ; #####.#.
                        dc.b $fe ; #######.
                        dc.b $fa ; #####.#.
                        dc.b $fa ; #####.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $fe ; #######.
                        
MapChar3a               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ae ; #.#.###.
                        dc.b $bf ; #.######
                        dc.b $ff ; ########
                        
MapChar3b               dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar3c               dc.b $f0 ; ####....
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $ab ; #.#.#.##
                        
MapChar3d               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $80 ; #.......
                        dc.b $e0 ; ###.....
                        dc.b $f8 ; #####...
                        dc.b $e0 ; ###.....
                        
MapChar3e               dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar3f               dc.b $ff ; ########
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $e0 ; ###.....
                        dc.b $e0 ; ###.....
                        dc.b $c0 ; ##......
                        dc.b $00 ; ........
                        
MapChar40               dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $3f ; ..######
                        dc.b $1f ; ...#####
                        dc.b $0f ; ....####
                        dc.b $43 ; .#....##
                        dc.b $e0 ; ###.....
                        dc.b $f8 ; #####...
                        
MapChar41               dc.b $ff ; ########
                        dc.b $f3 ; ####..##
                        dc.b $e1 ; ###....#
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $1e ; ...####.
                        dc.b $00 ; ........
                        
MapChar42               dc.b $fa ; #####.#.
                        dc.b $fa ; #####.#.
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        
MapChar43               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0c ; ....##..
                        
MapChar44               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $bb ; #.###.##
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $cc ; ##..##..
                        dc.b $00 ; ........
                        
MapChar45               dc.b $ab ; #.#.#.##
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $fa ; #####.#.
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        
MapChar46               dc.b $80 ; #.......
                        dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $e0 ; ###.....
                        
MapChar47               dc.b $fc ; ######..
                        dc.b $3e ; ..#####.
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $01 ; .......#
                        dc.b $07 ; .....###
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar48               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $e0 ; ###.....
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $3e ; ..#####.
                        dc.b $0f ; ....####
                        
MapChar49               dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $01 ; .......#
                        
MapChar4a               dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $e0 ; ###.....
                        dc.b $c0 ; ##......
                        
MapChar4b               dc.b $3e ; ..#####.
                        dc.b $7f ; .#######
                        dc.b $1f ; ...#####
                        dc.b $07 ; .....###
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar4c               dc.b $00 ; ........
                        dc.b $e0 ; ###.....
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        
MapChar4d               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $e0 ; ###.....
                        dc.b $fc ; ######..
                        dc.b $e0 ; ###.....
                        dc.b $f8 ; #####...
                        dc.b $fe ; #######.
                        
MapChar4e               dc.b $03 ; ......##
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar4f               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $fe ; #######.
                        dc.b $3e ; ..#####.
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        
MapChar50               dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        
MapChar51               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $e0 ; ###.....
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        
MapChar52               dc.b $00 ; ........
                        dc.b $78 ; .####...
                        dc.b $3c ; ..####..
                        dc.b $1e ; ...####.
                        dc.b $07 ; .....###
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar53               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $78 ; .####...
                        dc.b $1e ; ...####.
                        dc.b $0f ; ....####
                        
MapChar54               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $e0 ; ###.....
                        dc.b $38 ; ..###...
                        dc.b $0e ; ....###.
                        dc.b $07 ; .....###
                        
MapChar55               dc.b $fe ; #######.
                        dc.b $3a ; ..###.#.
                        dc.b $0e ; ....###.
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        
MapChar56               dc.b $ab ; #.#.#.##
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $fa ; #####.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $fa ; #####.#.
                        dc.b $fe ; #######.
                        
MapChar57               dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $f3 ; ####..##
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $bc ; #.####..
                        dc.b $af ; #.#.####
                        dc.b $bf ; #.######
                        
MapChar58               dc.b $00 ; ........
                        dc.b $80 ; #.......
                        dc.b $e0 ; ###.....
                        dc.b $78 ; .####...
                        dc.b $0f ; ....####
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        
MapChar59               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $70 ; .###....
                        dc.b $7c ; .#####..
                        dc.b $ff ; ########
                        
MapChar5a               dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        dc.b $e3 ; ###...##
                        dc.b $c1 ; ##.....#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar5b               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $cf ; ##..####
                        dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        
MapChar5c               dc.b $3c ; ..####..
                        dc.b $0e ; ....###.
                        dc.b $80 ; #.......
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $3c ; ..####..
                        dc.b $0f ; ....####
                        
MapChar5d               dc.b $00 ; ........
                        dc.b $0c ; ....##..
                        dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        
MapChar5e               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $e0 ; ###.....
                        dc.b $78 ; .####...
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
MapChar5f               dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $83 ; #.....##
                        dc.b $e3 ; ###...##
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
MapChar60               dc.b $3f ; ..######
                        dc.b $9f ; #..#####
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $0f ; ....####
                        
MapChar61               dc.b $ff ; ########
                        dc.b $ea ; ###.#.#.
                        dc.b $fa ; #####.#.
                        dc.b $fa ; #####.#.
                        dc.b $fe ; #######.
                        dc.b $fe ; #######.
                        dc.b $fa ; #####.#.
                        dc.b $fa ; #####.#.
                        
MapChar62               dc.b $fe ; #######.
                        dc.b $3f ; ..######
                        dc.b $0e ; ....###.
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        dc.b $0f ; ....####
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar63               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        
MapChar64               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        
MapChar65               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $fc ; ######..
                        dc.b $f0 ; ####....
                        dc.b $00 ; ........
                        dc.b $fc ; ######..
                        
MapChar66               dc.b $ff ; ########
                        dc.b $bf ; #.######
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar67               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar68               dc.b $00 ; ........
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fb ; #####.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar69               dc.b $00 ; ........
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar6a               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        
MapChar6b               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $ff ; ########
                        dc.b $f8 ; #####...
                        dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $fe ; #######.
                        
MapChar6c               dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar6d               dc.b $c0 ; ##......
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####

MapChar6e               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $e0 ; ###.....
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $f8 ; #####...
                        
MapChar6f               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $f0 ; ####....
                        dc.b $00 ; ........
                        
MapChar70               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $f8 ; #####...
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar71               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        
MapChar72               dc.b $af ; #.#.####
                        dc.b $bf ; #.######
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $bf ; #.######
                        
MapChar73               dc.b $e0 ; ###.....
                        dc.b $80 ; #.......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $80 ; #.......
                        dc.b $e0 ; ###.....
                        
MapChar74               dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $bf ; #.######
                        
MapChar75               dc.b $ff ; ########
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        dc.b $ff ; ########
                        
MapChar76               dc.b $80 ; #.......
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
MapChar77               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $e0 ; ###.....
                        dc.b $80 ; #.......
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f8 ; #####...
                        dc.b $ff ; ########
                        
MapChar78               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $f0 ; ####....
                        
MapChar79               dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        dc.b $af ; #.#.####
                        dc.b $bf ; #.######
                        dc.b $ff ; ########
                        
MapChar7a               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $f8 ; #####...
                        dc.b $c0 ; ##......
                        dc.b $f8 ; #####...
                        
MapChar7b               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $f0 ; ####....
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar7c               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $f0 ; ####....
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar7d               dc.b $00 ; ........
                        dc.b $f8 ; #####...
                        dc.b $e0 ; ###.....
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar7e               dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        dc.b $bf ; #.######
                        dc.b $ab ; #.#.#.##
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        dc.b $bf ; #.######
                        
MapChar7f               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $f0 ; ####....
                        dc.b $e0 ; ###.....
                        dc.b $80 ; #.......
                        
MapChar80               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar81               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        
MapChar82               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $bf ; #.######
                        
MapChar83               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $af ; #.#.####
                        dc.b $ff ; ########
                        
MapChar84               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $af ; #.#.####
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
MapChar85               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        dc.b $bf ; #.######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
MapChar86               dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
MapChar87               dc.b $fe ; #######.
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $e0 ; ###.....
                        dc.b $c0 ; ##......
                        dc.b $80 ; #.......
                        dc.b $80 ; #.......
                        dc.b $80 ; #.......
                        
MapChar88               dc.b $af ; #.#.####
                        dc.b $b5 ; #.##.#.#
                        dc.b $b5 ; #.##.#.#
                        dc.b $b5 ; #.##.#.#
                        dc.b $b5 ; #.##.#.#
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        
MapChar89               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar8a               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fb ; #####.##
                        dc.b $aa ; #.#.#.#.
                        
MapChar8b               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        
MapChar8c               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ab ; #.#.#.##
                        
MapChar8d               dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar8e               dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
MapChar8f               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $e0 ; ###.....
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
MapChar90               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $80 ; #.......
                        dc.b $ff ; ########
                        
MapChar91               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $ff ; ########
                        
MapChar92               dc.b $00 ; ........
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
MapChar93               dc.b $00 ; ........
                        dc.b $f8 ; #####...
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
MapChar94               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $f8 ; #####...
                        dc.b $e0 ; ###.....
                        dc.b $00 ; ........
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
MapChar95               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        
MapChar96               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $f0 ; ####....
                        
MapChar97               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
MapChar98               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
; -------------------------------------------------------------------------------------------------------------- ;
                        * = BH_MemSprites
; -------------------------------------------------------------------------------------------------------------- ;
Sprite_BayMap           equ  *   ; 
SP_Store_Map_00         dc.b %00000000, %00000000, %00000000 ; 5000 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5003 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5006 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5009 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 500c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 500f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5012 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5015 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5018 ; ........................
                        dc.b %00000111, %00000000, %00000000 ; 501b ; .....###................
                        dc.b %00000111, %00000000, %00000000 ; 501e ; .....###................
                        dc.b %00000000, %00000000, %00000000 ; 5021 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5024 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5027 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 502a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 502d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5030 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5033 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5036 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5039 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 503c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Map_01         dc.b %00000000, %00000000, %00000000 ; 5040 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5043 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5046 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5049 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 504c ; ........................
                        dc.b %00000000, %00011100, %00000000 ; 504f ; ...........###..........
                        dc.b %00000000, %00011100, %00000000 ; 5052 ; ...........###..........
                        dc.b %00000000, %00000000, %00000000 ; 5055 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5058 ; ........................
                        dc.b %00000111, %00000000, %00000000 ; 505b ; .....###................
                        dc.b %00000111, %00000000, %00000000 ; 505e ; .....###................
                        dc.b %00000000, %00000000, %00000000 ; 5061 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5064 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5067 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 506a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 506d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5070 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5073 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5076 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5079 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 507c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Map_02         dc.b %00000000, %00000000, %00000000 ; 5080 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5083 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5086 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5089 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 508c ; ........................
                        dc.b %00000000, %00011100, %00000000 ; 508f ; ...........###..........
                        dc.b %00000000, %00011100, %00000000 ; 5092 ; ...........###..........
                        dc.b %00000000, %00000000, %00000000 ; 5095 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5098 ; ........................
                        dc.b %00000111, %00000000, %00000000 ; 509b ; .....###................
                        dc.b %00000111, %00000000, %00000000 ; 509e ; .....###................
                        dc.b %00000000, %00000000, %00000000 ; 50a1 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50a4 ; ........................
                        dc.b %00000000, %00011100, %00000000 ; 50a7 ; ...........###..........
                        dc.b %00000000, %00011100, %00000000 ; 50aa ; ...........###..........
                        dc.b %00000000, %00000000, %00000000 ; 50ad ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50b0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50b3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50b6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50b9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50bc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Map_03         dc.b %00000000, %00000000, %00000000 ; 50c0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50c3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50c6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50c9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50cc ; ........................
                        dc.b %00000000, %00011100, %00000000 ; 50cf ; ...........###..........
                        dc.b %00000000, %00011100, %00000000 ; 50d2 ; ...........###..........
                        dc.b %00000000, %00000000, %00000000 ; 50d5 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50d8 ; ........................
                        dc.b %00000111, %00000000, %01110000 ; 50db ; .....###.........###....
                        dc.b %00000111, %00000000, %01110000 ; 50de ; .....###.........###....
                        dc.b %00000000, %00000000, %00000000 ; 50e1 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50e4 ; ........................
                        dc.b %00000000, %00011100, %00000000 ; 50e7 ; ...........###..........
                        dc.b %00000000, %00011100, %00000000 ; 50ea ; ...........###..........
                        dc.b %00000000, %00000000, %00000000 ; 50ed ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50f0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50f3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50f6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50f9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50fc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Map_04         dc.b %00000000, %00000000, %00000000 ; 5100 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5103 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5106 ; ........................
                        dc.b %00000000, %00011100, %00000000 ; 5109 ; ...........###..........
                        dc.b %00000000, %00011100, %00000000 ; 510c ; ...........###..........
                        dc.b %00000000, %00000000, %00000000 ; 510f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5112 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5115 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5118 ; ........................
                        dc.b %00000011, %10000000, %11100000 ; 511b ; ......###.......###.....
                        dc.b %00000011, %10000000, %11100000 ; 511e ; ......###.......###.....
                        dc.b %00000000, %00000000, %00000000 ; 5121 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5124 ; ........................
                        dc.b %00000000, %00011100, %00000000 ; 5127 ; ...........###..........
                        dc.b %00000000, %00011100, %00000000 ; 512a ; ...........###..........
                        dc.b %00000000, %00000000, %00000000 ; 512d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5130 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5133 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5136 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5139 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 513c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Map_05         dc.b %00000000, %00000000, %00000000 ; 5140 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5143 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5146 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5149 ; ........................
                        dc.b %00000000, %00000000, %01110000 ; 514c ; .................###....
                        dc.b %00000000, %00000000, %01110000 ; 514f ; .................###....
                        dc.b %00000001, %11000000, %00000000 ; 5152 ; .......###..............
                        dc.b %00000001, %11000000, %00000000 ; 5155 ; .......###..............
                        dc.b %00000000, %00000000, %00000000 ; 5158 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 515b ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 515e ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5161 ; ........................
                        dc.b %00000001, %11000001, %11000000 ; 5164 ; .......###.....###......
                        dc.b %00000001, %11000001, %11000000 ; 5167 ; .......###.....###......
                        dc.b %00000000, %00000000, %00000000 ; 516a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 516d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5170 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5173 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5176 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5179 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 517c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Map_06         dc.b %00000000, %00000000, %00000000 ; 5180 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5183 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5186 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5189 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 518c ; ........................
                        dc.b %00000000, %00011100, %00000000 ; 518f ; ...........###..........
                        dc.b %00000000, %00011100, %00000000 ; 5192 ; ...........###..........
                        dc.b %00000000, %00000000, %00000000 ; 5195 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5198 ; ........................
                        dc.b %00000011, %10000000, %00011100 ; 519b ; ......###..........###..
                        dc.b %00000011, %10000000, %00011100 ; 519e ; ......###..........###..
                        dc.b %00000000, %00000000, %00000000 ; 51a1 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51a4 ; ........................
                        dc.b %00000000, %00011100, %00000000 ; 51a7 ; ...........###..........
                        dc.b %00000000, %00011100, %00000000 ; 51aa ; ...........###..........
                        dc.b %00000000, %00000000, %00000000 ; 51ad ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51b0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51b3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51b6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51b9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51bc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Map_07         dc.b %00000000, %00000000, %00000000 ; 51c0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51c3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51c6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51c9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51cc ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51cf ; ........................
                        dc.b %00000001, %11000001, %11000000 ; 51d2 ; .......###.....###......
                        dc.b %00000001, %11000001, %11000000 ; 51d5 ; .......###.....###......
                        dc.b %00000000, %00000000, %00000000 ; 51d8 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51db ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51de ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51e1 ; ........................
                        dc.b %00000001, %11000000, %00000000 ; 51e4 ; .......###..............
                        dc.b %00000001, %11000000, %00000000 ; 51e7 ; .......###..............
                        dc.b %00000000, %00000000, %01110000 ; 51ea ; .................###....
                        dc.b %00000000, %00000000, %01110000 ; 51ed ; .................###....
                        dc.b %00000000, %00000000, %00000000 ; 51f0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51f3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51f6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51f9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51fc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Map_08         dc.b %00000000, %00000000, %00000000 ; 5200 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5203 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5206 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5209 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 520c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 520f ; ........................
                        dc.b %00000001, %11000001, %11000000 ; 5212 ; .......###.....###......
                        dc.b %00000001, %11000001, %11000000 ; 5215 ; .......###.....###......
                        dc.b %00000000, %00000000, %00000000 ; 5218 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 521b ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 521e ; ........................
                        dc.b %00000111, %00000000, %00000000 ; 5221 ; .....###................
                        dc.b %00000111, %00000001, %11000000 ; 5224 ; .....###.......###......
                        dc.b %00000000, %00000001, %11000000 ; 5227 ; ...............###......
                        dc.b %00000000, %01110000, %00000000 ; 522a ; .........###............
                        dc.b %00000000, %01110000, %00000000 ; 522d ; .........###............
                        dc.b %00000000, %00000000, %00000000 ; 5230 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5233 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5236 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5239 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 523c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SpriteBasePtr           set (BH_MemSprites - BH_MemVicGfx) / BH_SpriteDataLen
; -------------------------------------------------------------------------------------------------------------- ;
SP_Ptr_Map_00           =   SpriteBasePtr  + $00 ; $40 ; fleet 1 ship
SP_Ptr_Map_01           =   SpriteBasePtr  + $01 ; $41 ; fleet 2 ships
SP_Ptr_Map_02           =   SpriteBasePtr  + $02 ; $42 ; fleet 3 ships
SP_Ptr_Map_03           =   SpriteBasePtr  + $03 ; $43 ; fleet 4 ships
SP_Ptr_Map_04           =   SpriteBasePtr  + $04 ; $44 ; fleet 4 ships 1 n
SP_Ptr_Map_05           =   SpriteBasePtr  + $05 ; $45 ; fleet 4 ships 1 ne
SP_Ptr_Map_06           =   SpriteBasePtr  + $06 ; $46 ; fleet 4 ships 1 e
SP_Ptr_Map_07           =   SpriteBasePtr  + $07 ; $47 ; fleet 4 ships 1 se
SP_Ptr_Map_08           =   SpriteBasePtr  + $08 ; $48 ; fleet 5 ships
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_00             set BH_SpriteStore + $00 * BH_SpriteDataLen ; $5000 - $40
SP_Store_01             set BH_SpriteStore + $01 * BH_SpriteDataLen ; $5040 - $41
SP_Store_02             set BH_SpriteStore + $02 * BH_SpriteDataLen ; $5080 - $42
SP_Store_03             set BH_SpriteStore + $03 * BH_SpriteDataLen ; $50c0 - $43
SP_Store_04             set BH_SpriteStore + $04 * BH_SpriteDataLen ; $5100 - $44
SP_Store_05             set BH_SpriteStore + $05 * BH_SpriteDataLen ; $5140 - $45
SP_Store_06             set BH_SpriteStore + $06 * BH_SpriteDataLen ; $5180 - $46
SP_Store_07             set BH_SpriteStore + $07 * BH_SpriteDataLen ; $51c0 - $47
SP_Store_08             set BH_SpriteStore + $08 * BH_SpriteDataLen ; $5200 - $48
; -------------------------------------------------------------------------------------------------------------- ;
